FILENAME det72 'D:\Jim\CEXdata\7273\09034-0009-Data.txt';
FILENAME det73 'D:\Jim\CEXdata\7273\09034-0010-Data.txt';
**************************************************************************
Section 1
READ IN RAW DATA
**************************************************************************;

%MACRO read(yr);
DATA fmly&yr;
INFILE det&yr;
INPUT rectype  1-2 @;
IF rectype=1 THEN INPUT
        newid 3-7
        year  8
        type  9
		finlwt 10-17
        @;
RETAIN newid year type finlwt;
IF rectype=4 THEN INPUT
        d_homevalue 15-21
	    @;
RETAIN d_homevalue;
IF rectype=5 THEN INPUT
        d_rentequiv 3-9
		totexp_det 10-19
	    @;
RETAIN d_rentequiv totexp_det;
IF rectype=10 THEN INPUT
        famrel1 3
		famage1 4-5
        famrel2 12
		famage2 13-14
		@;
RETAIN famrel1 famage1 famrel2 famage2;
IF rectype=11 THEN INPUT
        famrel3 3
		famage3 4-5
        famrel4 12
		famage4 13-14
		@;
RETAIN famrel3 famage3 famrel4 famage4;
IF rectype=12 THEN INPUT
        famrel5 3
		famage5 4-5
        famrel6 12
		famage6 13-14
		@;
RETAIN famrel5 famage5 famrel6 famage6;
IF rectype=13 THEN INPUT
        famrel7 3
		famage7 4-5
        famrel8 12
		famage8 13-14
		@;
RETAIN famrel7 famage7 famrel8 famage8;
IF rectype=14 THEN INPUT
        famrel9 3
		famage9 4-5
        famrel10 12
		famage10 13-14
		@;
RETAIN famrel9 famage9 famrel10 famage10;
IF rectype=15 THEN INPUT
        famrel11 3
		famage11 4-5
        famrel12 12
		famage12 13-14
		@;
RETAIN famrel11 famage11 famrel12 famage12;
IF rectype=16 THEN INPUT
        famrel13 3
		famage13 4-5
        famrel14 12
		famage14 13-14
		@;
RETAIN famrel13 famage13 famrel14 famage14;
IF rectype=17 THEN INPUT
        famrel15 3
		famage15 4-5
        famrel16 12
		famage16 13-14
		@;
RETAIN famrel15 famage15 famrel16 famage16;
IF rectype=18 THEN INPUT
        famrel17 3
		famage17 4-5
        famrel18 12
		famage18 13-14
		@;

IF rectype=18;

* CALCULATE FAMILY SIZE;
ARRAY fam(1:18) famrel1-famrel18; 
ARRAY age(1:18) famage1-famage18; 
ARRAY kid(1:18); 
ARRAY memb(1:18); 
ARRAY senior(1:18); 


DO t=1 TO 18; 
   IF fam(t) GT 0 AND age(t) LT 18 THEN kid(t)=1;
   ELSE kid(t)=0; 
 
   IF 1 LE fam(t) LE 6 THEN memb(t)=1;   
   ELSE memb(t)=0; 

   IF fam(t) GT 0 AND age(t) GE 65 THEN senior(t)=1;
   ELSE senior(t)=0; 
END;

d_perslt18=SUM(OF kid1-kid18);
d_fam_memb=SUM(OF memb1-memb18);
d_persot64=SUM(OF senior1-senior18);

IF d_homevalue=9999999 THEN d_homevalue=.;
IF d_rentequiv=9999999 THEN d_rentequiv=.;
d_rentequiv=d_rentequiv/100;
totexp_det=totexp_det/100;

KEEP newid year d_homevalue d_rentequiv totexp_det 
     d_perslt18 d_fam_memb d_persot64;
RUN;
PROC MEANS;
RUN;

DATA detail&yr;
INFILE det&yr;
INPUT rectype  1-2 @;
IF rectype=19 THEN INPUT
	    newid 3-7
	    itemcode 8-12
		itemvalue 13-22;
IF rectype=19;
itemvalue=itemvalue/100;

* SOME ITEMCODES ARE NEGATIVE;
IF itemcode IN(27002 27003) THEN itemvalue=(-1)*itemvalue;

RUN;

* FOOD AT HOME;
* NOTE: INCLUDE 19103-19108 HERE, EVEN THOUGH CROSS-WALK PUTS THESE IN FOOD AWAY, 
  BECAUSE THIS MATCHES 1980 DATA;
PROC MEANS SUM NOPRINT DATA=detail&yr;
BY newid;
VAR itemvalue;
WHERE itemcode BETWEEN 1001 AND 1003 OR
	itemcode BETWEEN 19103 AND 19108;
OUTPUT OUT=constemp1(DROP= _FREQ_ _TYPE_) SUM=d_fdhome;
RUN;

* FOOD AWAY;
PROC MEANS SUM NOPRINT DATA=detail&yr;
BY newid;
VAR itemvalue;
WHERE itemcode BETWEEN 1004 AND 1006 OR
	itemcode BETWEEN 1008 AND 1011 OR
	itemcode BETWEEN 19109 AND 19114 OR
	itemcode BETWEEN 19133 AND 19135 OR
	itemcode BETWEEN 19137 AND 19138 OR
	itemcode BETWEEN 24092 AND 24093; 
OUTPUT OUT=constemp2(DROP= _FREQ_ _TYPE_) SUM=d_fdaway;
RUN;

* ALCOHOL;
PROC MEANS SUM NOPRINT DATA=detail&yr;
BY newid;
VAR itemvalue;
WHERE itemcode BETWEEN 2001 AND 2004 OR
	itemcode BETWEEN 19115 AND 19126 OR
	itemcode BETWEEN 24094 AND 24095;
OUTPUT OUT=constemp3(DROP= _FREQ_ _TYPE_) SUM=d_alcohol;
RUN;

* ALCOHOL CONSUMED OFF PREMISE;
PROC MEANS SUM NOPRINT DATA=detail&yr;
BY newid;
VAR itemvalue;
WHERE itemcode BETWEEN 2001 AND 2003 OR
	itemcode BETWEEN 19121 AND 19126 OR
	itemcode=24095;
OUTPUT OUT=constemp3b(DROP= _FREQ_ _TYPE_) SUM=d_alcohol_hm;
RUN;

* ALCOHOL AT RESTAURANTS;
PROC MEANS SUM NOPRINT DATA=detail&yr;
BY newid;
VAR itemvalue;
WHERE itemcode BETWEEN 19115 AND 19120 OR
	itemcode IN (2004 24095);
OUTPUT OUT=constemp3c(DROP= _FREQ_ _TYPE_) SUM=d_alcohol_away;
RUN;

* RENT;
PROC MEANS SUM NOPRINT DATA=detail&yr;
BY newid;
VAR itemvalue;
WHERE itemcode BETWEEN 4001 AND 4008 OR
	itemcode=7196;
OUTPUT OUT=constemp4(DROP= _FREQ_ _TYPE_) SUM=d_rent;
RUN;

* OWN DWELLING;
PROC MEANS SUM NOPRINT DATA=detail&yr;
BY newid;
VAR itemvalue;
WHERE itemcode BETWEEN 4009 AND 4088 OR
	itemcode=7195;
OUTPUT OUT=constemp5(DROP= _FREQ_ _TYPE_) SUM=d_owndwell;
RUN;

* OTHER LODGING;
PROC MEANS SUM NOPRINT DATA=detail&yr;
BY newid;
VAR itemvalue;
WHERE itemcode BETWEEN 4089 AND 4090 OR
	itemcode BETWEEN 18001 AND 18037 OR
	itemcode BETWEEN 19127 AND 19132 OR
	itemcode BETWEEN 24002 AND 24081 OR
	itemcode BETWEEN 24096 AND 24097 OR
	itemcode BETWEEN 26608 AND 26609;
OUTPUT OUT=constemp6(DROP= _FREQ_ _TYPE_) SUM=d_othlodge;
RUN;

* UTILITIES;
PROC MEANS SUM NOPRINT DATA=detail&yr;
BY newid;
VAR itemvalue;
WHERE itemcode BETWEEN 5001 AND 5012 OR
	itemcode BETWEEN 5014 AND 5015 OR
	itemcode BETWEEN 6001 AND 6005;
OUTPUT OUT=constemp7(DROP= _FREQ_ _TYPE_) SUM=d_utility;
RUN;

* HOUSEHOLD OPERATIONS;
PROC MEANS SUM NOPRINT DATA=detail&yr;
BY newid;
VAR itemvalue;
WHERE itemcode BETWEEN 6006 AND 6065 OR
	itemcode BETWEEN 6080 AND 6084 OR
	itemcode BETWEEN 7142 AND 7193 OR
	itemcode BETWEEN 7197 AND 7222 OR
	itemcode BETWEEN 7231 AND 7251 OR
	itemcode BETWEEN 7257 AND 7260 OR
	itemcode IN(6078 7287 5013);
OUTPUT OUT=constemp8(DROP= _FREQ_ _TYPE_) SUM=d_houseop;
RUN;

* HOUSE FURNISHINGS;
PROC MEANS SUM NOPRINT DATA=detail&yr;
BY newid;
VAR itemvalue;
WHERE itemcode BETWEEN 7001 AND 7141 OR
	itemcode BETWEEN 26003 AND 26137 OR
	itemcode BETWEEN 26513 AND 26516 OR
	itemcode BETWEEN 26606 AND 26607 OR
	itemcode=7194;
OUTPUT OUT=constemp9(DROP= _FREQ_ _TYPE_) SUM=d_hfurn;
RUN;

* LUGGAGE;
PROC MEANS SUM NOPRINT DATA=detail&yr;
BY newid;
VAR itemvalue;
WHERE itemcode IN (7118 7128 7129 26513);
OUTPUT OUT=constemp9b(DROP= _FREQ_ _TYPE_) SUM=d_luggage;
RUN;

* APPAREL;
PROC MEANS SUM NOPRINT DATA=detail&yr;
BY newid;
VAR itemvalue;
WHERE itemcode BETWEEN 8001 AND 8004 OR
	itemcode BETWEEN 9001 AND 9079 OR
	itemcode BETWEEN 10001 AND 10079 OR
	itemcode BETWEEN 11001 AND 11079 OR
	itemcode BETWEEN 12001 AND 12079 OR
	itemcode BETWEEN 13001 AND 13091 OR
	itemcode BETWEEN 14001 AND 14009 OR
	itemcode BETWEEN 26143 AND 26512;
OUTPUT OUT=constemp10(DROP= _FREQ_ _TYPE_) SUM=d_clothing;
RUN;

* VEHICLES;
PROC MEANS SUM NOPRINT DATA=detail&yr;
BY newid;
VAR itemvalue;
WHERE itemcode BETWEEN 15001 AND 15038 OR
	itemcode BETWEEN 20012 AND 20013 OR
	itemcode BETWEEN 26548 AND 26585 OR
	itemcode IN (20056 20059 26589 26591 26596 26598 26600);
OUTPUT OUT=constemp11(DROP= _FREQ_ _TYPE_) SUM=d_vehic;
RUN;


* AUTOS;
PROC MEANS SUM NOPRINT DATA=detail&yr;
BY newid;
VAR itemvalue;
WHERE itemcode BETWEEN 15001 AND 15007 OR
	itemcode BETWEEN 15011 AND 15018 OR
	itemcode BETWEEN 15020 AND 15026 OR
	itemcode BETWEEN 15030 AND 15037 OR
	itemcode IN (15009 15028);
OUTPUT OUT=constemp11b(DROP=_TYPE_ RENAME=(_FREQ_=num_cars_purch)) SUM=d_autos;
RUN;


* AUTO FINANCING;
PROC MEANS SUM NOPRINT DATA=detail&yr;
BY newid;
VAR itemvalue;
WHERE itemcode BETWEEN 15040 AND 15053;
OUTPUT OUT=constemp11c(DROP= _FREQ_ _TYPE_) SUM=d_autofin;
RUN;


* GAS AND MOTOR OIL;
PROC MEANS SUM NOPRINT DATA=detail&yr;
BY newid;
VAR itemvalue;
WHERE itemcode BETWEEN 15069 AND 15073 OR
	itemcode BETWEEN 19001 AND 19006 OR
	itemcode BETWEEN 19019 AND 19036 OR
	itemcode BETWEEN 19097 AND 19102 OR
	itemcode BETWEEN 20032 AND 20034 OR
	itemcode BETWEEN 24101 AND 24104 OR
	itemcode IN(19136 20004 20015 20063 20070 24089);
OUTPUT OUT=constemp12(DROP= _FREQ_ _TYPE_) SUM=d_gas;
RUN;

* OTHER VEHICLE EXPENSES;
PROC MEANS SUM NOPRINT DATA=detail&yr;
BY newid;
VAR itemvalue;
WHERE itemcode BETWEEN 15039 AND 15068 OR
	itemcode BETWEEN 15074 AND 15144 OR
	itemcode BETWEEN 15157 AND 15158 OR
	itemcode BETWEEN 19007 AND 19018 OR
	itemcode BETWEEN 19073 AND 19084 OR
	itemcode BETWEEN 20005 AND 20011 OR
	itemcode BETWEEN 20016 AND 20022 OR
	itemcode BETWEEN 20029 AND 20031 OR
	itemcode BETWEEN 20035 AND 20055 OR
	itemcode BETWEEN 20064 AND 20069 OR
	itemcode BETWEEN 20071 AND 20088 OR
	itemcode BETWEEN 24090 AND 24091 OR
	itemcode IN(20003 20014 20062);
OUTPUT OUT=constemp13(DROP= _FREQ_ _TYPE_) SUM=d_othvehic;
RUN;

* PUBLIC TRANSPORTATION;
PROC MEANS SUM NOPRINT DATA=detail&yr;
BY newid;
VAR itemvalue;
WHERE itemcode BETWEEN 15145 AND 15156 OR
	itemcode BETWEEN 19037 AND 19072 OR
	itemcode BETWEEN 19085 AND 19096;
OUTPUT OUT=constemp14(DROP= _FREQ_ _TYPE_) SUM=d_pubtrans;
RUN;

* HEALTH CARE;
PROC MEANS SUM NOPRINT DATA=detail&yr;
BY newid;
VAR itemvalue;
WHERE itemcode BETWEEN 16001 AND 16002 OR
	itemcode BETWEEN 16006 AND 16039 OR
	itemcode=26610;
OUTPUT OUT=constemp15(DROP= _FREQ_ _TYPE_) SUM=d_health;
RUN;

* ENTERTAINMENT;
PROC MEANS SUM NOPRINT DATA=detail&yr;
BY newid;
VAR itemvalue;
WHERE itemcode BETWEEN 6066 AND 6077 OR
	itemcode BETWEEN 7223 AND 7230 OR
	itemcode BETWEEN 7261 AND 7283 OR
	itemcode BETWEEN 7285 AND 7286 OR
	itemcode BETWEEN 7288 AND 7289 OR
	itemcode BETWEEN 19139 AND 19162 OR
	itemcode BETWEEN 20001 AND 20002 OR
	itemcode BETWEEN 20023 AND 20028 OR
	itemcode BETWEEN 20057 AND 20058 OR
	itemcode BETWEEN 20060 AND 20061 OR
	itemcode BETWEEN 21001 AND 21069 OR
	itemcode BETWEEN 21071 AND 21100 OR
	itemcode BETWEEN 24098 AND 24100 OR
	itemcode BETWEEN 26517 AND 26531 OR
	itemcode BETWEEN 26533 AND 26547 OR
	itemcode BETWEEN 26586 AND 26588 OR
	itemcode BETWEEN 26592 AND 26595 OR
	itemcode BETWEEN 26601 AND 26604 OR
	itemcode IN(6079 26590 26597 26599);
OUTPUT OUT=constemp16(DROP= _FREQ_ _TYPE_) SUM=d_entertain;
RUN;

* VIDEO AUDIO;
PROC MEANS SUM NOPRINT DATA=detail&yr;
BY newid;
VAR itemvalue;
WHERE itemcode BETWEEN 21008 AND 21023 OR
	itemcode BETWEEN 26517 AND 26531;
OUTPUT OUT=constemp16b(DROP= _FREQ_ _TYPE_) SUM=d_tv;
RUN;

* PERSONAL CARE;
PROC MEANS SUM NOPRINT DATA=detail&yr;
BY newid;
VAR itemvalue;
WHERE itemcode BETWEEN 7252 AND 7256 OR
	itemcode BETWEEN 17001 AND 17016 OR
	itemcode BETWEEN 26138 AND 26142;
OUTPUT OUT=constemp17(DROP= _FREQ_ _TYPE_) SUM=d_perscare;
RUN;

* READING;
PROC MEANS SUM NOPRINT DATA=detail&yr;
BY newid;
VAR itemvalue;
WHERE itemcode BETWEEN 22001 AND 22005 OR
	itemcode IN(7284 21070 26532 26605);
OUTPUT OUT=constemp18(DROP= _FREQ_ _TYPE_) SUM=d_read;
RUN;

* EDUCATION;
PROC MEANS SUM NOPRINT DATA=detail&yr;
BY newid;
VAR itemvalue;
WHERE itemcode BETWEEN 23001 AND 23030 OR
	itemcode=26611;
OUTPUT OUT=constemp19(DROP= _FREQ_ _TYPE_) SUM=d_educ;
RUN;

* TOBACCO;
PROC MEANS SUM NOPRINT DATA=detail&yr;
BY newid;
VAR itemvalue;
WHERE itemcode BETWEEN 3001 AND 3003;
OUTPUT OUT=constemp20(DROP= _FREQ_ _TYPE_) SUM=d_tobacco;
RUN;

* MISCELLANEOUS;
PROC MEANS SUM NOPRINT DATA=detail&yr;
BY newid;
VAR itemvalue;
WHERE itemcode BETWEEN 24082 AND 24088 OR
	itemcode BETWEEN 27002 AND 27003 OR
	itemcode IN(24001 24105 26612);
OUTPUT OUT=constemp21(DROP= _FREQ_ _TYPE_) SUM=d_miscel;
RUN;

* CASH CONTRIBUTIONS;
PROC MEANS SUM NOPRINT DATA=detail&yr;
BY newid;
VAR itemvalue;
WHERE itemcode BETWEEN 26001 AND 26002 OR
	itemcode BETWEEN 26613 AND 26618;
OUTPUT OUT=constemp22(DROP= _FREQ_ _TYPE_) SUM=d_cashco;
RUN;

* LIFE INSURANCE;
PROC MEANS SUM NOPRINT DATA=detail&yr;
BY newid;
VAR itemvalue;
* verified that if exclude 25017 it matches lifeins+othins in summary file exactly;
* HOWEVER THE SUMMARY VARIABLE IS WRONG (SEE P. 38 IN THE 72-73 CODEBOOK). TO GET
  THE RIGHT MEASURE NEED TO EXCLUDE 25002 & 25005;
WHERE itemcode BETWEEN 25003 AND 25004 
	OR itemcode BETWEEN 25006 AND 25010 
	OR itemcode=25017
	OR itemcode=25001;
OUTPUT OUT=constemp23(DROP= _FREQ_ _TYPE_) SUM=d_lifeins;
RUN;

* RETIREMENT;
PROC MEANS SUM NOPRINT DATA=detail&yr;
BY newid;
VAR itemvalue;
* verified that if only include first condition and add 25017 
  it matches retpen in summary file exactly;
WHERE itemcode BETWEEN 25011 AND 25016 
   OR itemcode BETWEEN 16003 AND 16005;
OUTPUT OUT=constemp24(DROP= _FREQ_ _TYPE_) SUM=d_retire;
RUN;

* BEFORE TAX MONEY INCOME;
PROC MEANS SUM NOPRINT DATA=detail&yr;
BY newid;
VAR itemvalue;
WHERE itemcode BETWEEN 27004 AND 27026 OR
	itemcode BETWEEN 27030 AND 27031 OR
	itemcode=27001;
OUTPUT OUT=constemp25(DROP= _FREQ_ _TYPE_) SUM=d_fincbtax;
RUN;

* VEHICLE FINANCING, THIS IS TO GET MATCH FOR COMPARISON TO NIPA;
PROC MEANS SUM NOPRINT DATA=detail&yr;
BY newid;
VAR itemvalue;
WHERE itemcode BETWEEN 15039 AND 15056 OR
	itemcode BETWEEN 20081 AND 20088;
OUTPUT OUT=constemp26(DROP= _FREQ_ _TYPE_) SUM=d_vehfin;
RUN;

* OTHER APPAREL, THIS IS TO GET MATCH FOR COMPARISON TO NIPA;
PROC MEANS SUM NOPRINT DATA=detail&yr;
BY newid;
VAR itemvalue;
WHERE itemcode BETWEEN 8001 AND 8004 OR
	itemcode BETWEEN 9077 AND 9079 OR
	itemcode BETWEEN 10077 AND 10079 OR
	itemcode BETWEEN 11077 AND 11079 OR
	itemcode BETWEEN 12077 AND 12079 OR
	itemcode BETWEEN 13079 AND 13083 OR
	itemcode BETWEEN 14001 AND 14009 OR
	itemcode BETWEEN 26509 AND 26512;
OUTPUT OUT=constemp27(DROP= _FREQ_ _TYPE_) SUM=d_othapl;
RUN;


DATA fam_det_final&yr;
MERGE fmly&yr(IN=in1)
constemp1 constemp2 constemp3 constemp3b constemp3c constemp4 
constemp5 constemp6 constemp7 constemp8 constemp9 constemp9b
constemp10 constemp11 constemp11b constemp11c constemp12 constemp13 constemp14 
constemp15 constemp16 constemp16b constemp17
constemp18 constemp19 constemp20 constemp21 constemp22 constemp23 constemp24 constemp25
constemp26 constemp27; 
BY newid;
IF in1;

ARRAY missings 
   d_fdhome d_fdaway d_alcohol d_alcohol_hm d_alcohol_away
   d_rent d_owndwell d_othlodge d_utility d_houseop 
   d_hfurn d_luggage d_clothing d_vehic num_cars_purch d_autos d_autofin
   d_gas d_othvehic d_pubtrans d_health d_entertain 
   d_tv d_perscare d_read d_educ d_tobacco d_miscel d_cashco d_lifeins d_retire d_fincbtax
   d_vehfin d_othapl;
DO OVER missings; 
   IF missings=. THEN missings=0;
END; 

RUN;

PROC MEANS;
RUN;

%MEND read;


%read(72);
%read(73);

DATA cexdata.fam_det_final7273;
SET fam_det_final72 fam_det_final73; 

year=1970+year;
newid=1000000*year+newid; 

DROP year;
RUN;
PROC SORT DATA=cexdata.fam_det_final7273;
   BY newid;
RUN;
